/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ContainerDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Directive;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveIterator;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveList;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserIOException;

public class FileLevelContainer
extends ContainerDirective {
    protected static final byte STATUS_NORMAL = 0;
    protected static final byte STATUS_CREATED = 1;
    protected static final byte STATUS_DELETED = 2;
    protected static final byte STATUS_MODIFIED = 4;
    private String filePath;

    protected FileLevelContainer() {
    }

    protected FileLevelContainer(String string) {
        this.filePath = string;
    }

    protected FileLevelContainer(String string, DirectiveList directiveList) {
        this.filePath = string;
        this.directiveList = directiveList;
        directiveList.setParent(this);
    }

    protected void setFilePath(String string, boolean bl) {
        ((FileLevelContainer)this.getTargetObject((boolean)bl)).filePath = string;
    }

    public void setFilePath(String string) {
        this.setFilePath(string, true);
    }

    public String getFilePath(boolean bl) {
        return ((FileLevelContainer)this.getSourceObject((boolean)bl)).filePath;
    }

    public String getFilePath() {
        return this.getFilePath(true);
    }

    public String getValue() {
        return this.getFilePath();
    }

    public String getName() {
        return "FileLevelContainer";
    }

    protected void writeChanges(String string) throws ParserIOException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(String.valueOf(this.getFilePath()) + string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParserIOException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new ParserIOException(iOException.getMessage());
        }
        printWriter.print(this.toString(true));
        printWriter.close();
    }

    public String toString(boolean bl, boolean bl2) {
        FileLevelContainer fileLevelContainer = (FileLevelContainer)this.getSourceObject(bl2);
        String string = new String();
        if (bl && fileLevelContainer.comment != null) {
            string = fileLevelContainer.comment;
        }
        string = String.valueOf(string) + fileLevelContainer.directiveList.toString(bl, bl2);
        return string;
    }

    public String toString(boolean bl) {
        return this.toString(bl, true);
    }

    public String toString() {
        return this.toString(false, true);
    }

    protected byte getStatus() {
        if (this.isCreated()) {
            return 1;
        }
        if (this.isDeleted()) {
            return 2;
        }
        if (this.hasTempCloneCreated(this)) {
            return 4;
        }
        return 0;
    }

    private boolean hasTempCloneCreated(ContainerDirective containerDirective) {
        if (containerDirective == null) {
            return false;
        }
        if (containerDirective.hasTempClone()) {
            return true;
        }
        DirectiveIterator directiveIterator = containerDirective.getChildren(true, false);
        while (directiveIterator.hasNext()) {
            boolean bl;
            Directive directive = (Directive)directiveIterator.next();
            if (directive.hasTempClone()) {
                return true;
            }
            if (!(directive instanceof ContainerDirective) || !(bl = this.hasTempCloneCreated((ContainerDirective)directive))) continue;
            return true;
        }
        return false;
    }

    protected void copyFrom(Directive directive) {
        super.copyFrom(directive);
        this.filePath = ((FileLevelContainer)directive).filePath;
    }

    public void removeChildren() {
        DirectiveIterator directiveIterator = this.getChildren();
        while (directiveIterator.hasNext()) {
            Directive directive = (Directive)directiveIterator.next();
            ContainerDirective containerDirective = (ContainerDirective)directive.getParent();
            containerDirective.removeChild(directive);
        }
    }
}

